package com.xforceplus.ultraman.app.purchaserinvoicesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 验真相关信息
 * </p>
 *
 * @author ultraman
 * @since 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceVerify implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 验真人姓名
   */
  private String verifyUserName;

  /**
   * 验真人id
   */
  private Long verifyUserId;

  /**
   * 验真时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime verifyTime;

  /**
   * 验真次数
   */
  private Long verifyNumber;

  /**
   * 验真备注
   */
  private String verifyRemark;

  /**
   * 验真状态
   */
  private String verifyStatus;

  /**
   * 验签状态
   */
  private String verifySignStatus;

  /**
   * 数据状态
   */
  private String dataStatus;

  /**
   * 税件验真任务id
   */
  private String taxTaskId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织id
   */
  private Long orgId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("verify_user_name", verifyUserName);
      map.put("verify_user_id", verifyUserId);
      map.put("verify_time", BocpGenUtils.toTimestamp(verifyTime));
      map.put("verify_number", verifyNumber);
      map.put("verify_remark", verifyRemark);
      map.put("verify_status", verifyStatus);
      map.put("verify_sign_status", verifySignStatus);
      map.put("data_status", dataStatus);
      map.put("tax_task_id", taxTaskId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_id", orgId);
      return map;
  }

  public static InvoiceVerify fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceVerify entity = new InvoiceVerify();
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setVerifyUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVerifyUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVerifyTime(null);
      }
    }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyNumber((Long)obj);
        } else if(obj instanceof String) {
          entity.setVerifyNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setVerifyNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifySignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
