package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum InvoiceStatus {

    _1("1", "正常"),
    _2("2", "作废"),
    _3("3", "已红冲"),
    _4("4", "部分红冲"),
    _6("6", "红字发票待确认"),
    _7("7", "异常"),
    _8("8", "失控"),
    _5("5", "全额冲红");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code) {
        return Stream.of(InvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
