package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 农产品处理类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum NcpHandleType {

    _0("0", "无"),
    _1("1", "属于自产农产品销售发票"),
    _2("2", "不属于自产农产品销售发票"),
    _3("3", "按票面税额抵扣"),
    _4("4", "按票面金额和基础扣除率计算抵扣"),
    _5("5", "部分属于自产农产品销售发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpHandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpHandleType fromCode(String code) {
        return Stream.of(NcpHandleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
