package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 接收状态
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum ReceiveStatus {

    _1("1", "接收成功"),
    _2("2", "接收失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceiveStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiveStatus fromCode(String code) {
        return Stream.of(ReceiveStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
