package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真方式
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum VerifyWay {

    _1("1", "手工输入"),
    _2("2", "外部接口"),
    _3("3", "二维码扫描"),
    _4("4", "系统自动"),
    _5("5", "文件导入"),
    _6("6", "扫描触发"),
    _7("7", "底账触发"),
    _8("8", "发票池触发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VerifyWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyWay fromCode(String code) {
        return Stream.of(VerifyWay.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
