package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 快照格式
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public enum SnapshotFormat {

    DIRECT("direct", "直接存取"),
    FILE("file", "文件存取");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SnapshotFormat(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SnapshotFormat fromCode(String code) {
        return Stream.of(SnapshotFormat.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
