package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.validator;

import com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-04-11
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(IssueFlag.class)) {
            isValid = null != IssueFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IssueFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialInvoiceFlag.class)) {
            isValid = null != SpecialInvoiceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialInvoiceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleListFlag.class)) {
            isValid = null != SaleListFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SaleListFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogStatus.class)) {
            isValid = null != RecogStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RecogSheet.class)) {
            isValid = null != RecogSheet.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecogSheet.class.getSimpleName());
            }
        }
        if(clazz.equals(FileType.class)) {
            isValid = null != FileType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileType.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatus.class)) {
            isValid = null != VerifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifySignStatus.class)) {
            isValid = null != VerifySignStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifySignStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStyle.class)) {
            isValid = null != AuthStyle.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStyle.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = null != AuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoAuthReason.class)) {
            isValid = null != NoAuthReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoAuthReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceOrig.class)) {
            isValid = null != InvoiceOrig.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceOrig.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = null != CooperateFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = null != ComplianceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = null != RetreatStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(HangStatus.class)) {
            isValid = null != HangStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, HangStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PaymentStatus.class)) {
            isValid = null != PaymentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaymentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BlackStatus.class)) {
            isValid = null != BlackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BlackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutStatus.class)) {
            isValid = null != TurnOutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TurnOutType.class)) {
            isValid = null != TurnOutType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TurnOutType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(DataStatus.class)) {
            isValid = null != DataStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRateType.class)) {
            isValid = null != TaxRateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxRateType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPreFlag.class)) {
            isValid = null != TaxPreFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPreFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(DiscountFlag.class)) {
            isValid = null != DiscountFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DiscountFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceBusinessType.class)) {
            isValid = null != InvoiceBusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceBusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(ErrorCode.class)) {
            isValid = null != ErrorCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ErrorCode.class.getSimpleName());
            }
        }
        if(clazz.equals(SendStatus.class)) {
            isValid = null != SendStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SendStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SendType.class)) {
            isValid = null != SendType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SendType.class.getSimpleName());
            }
        }
        if(clazz.equals(BackStatus.class)) {
            isValid = null != BackStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BackStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveStatus.class)) {
            isValid = null != ReceiveStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiveStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FileOrigin.class)) {
            isValid = null != FileOrigin.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FileOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyWay.class)) {
            isValid = null != VerifyWay.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyWay.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = null != ProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsOpen.class)) {
            isValid = null != IsOpen.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsOpen.class.getSimpleName());
            }
        }
        if(clazz.equals(ElSyncFlag.class)) {
            isValid = null != ElSyncFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ElSyncFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceCategory.class)) {
            isValid = null != InvoiceCategory.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceCategory.class.getSimpleName());
            }
        }
        if(clazz.equals(AreaType.class)) {
            isValid = null != AreaType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AreaType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsCancelCheck.class)) {
            isValid = null != IsCancelCheck.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsCancelCheck.class.getSimpleName());
            }
        }
        if(clazz.equals(SaleConfirmStatus.class)) {
            isValid = null != SaleConfirmStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SaleConfirmStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReportStatus.class)) {
            isValid = null != ReportStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReportStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReimbursementStatus.class)) {
            isValid = null != ReimbursementStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReimbursementStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = null != RedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ManageStatus.class)) {
            isValid = null != ManageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InspectStatus.class)) {
            isValid = null != InspectStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InspectStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpType.class)) {
            isValid = null != NcpType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpHandleType.class)) {
            isValid = null != NcpHandleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpHandleType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpHandleStatus.class)) {
            isValid = null != NcpHandleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpHandleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryStatus.class)) {
            isValid = null != EntryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(EntryTabStatus.class)) {
            isValid = null != EntryTabStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EntryTabStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpOperateType.class)) {
            isValid = null != NcpOperateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpOperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(NcpManageStatus.class)) {
            isValid = null != NcpManageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NcpManageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceFlag.class)) {
            isValid = null != NoComplianceFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceType.class)) {
            isValid = null != NoComplianceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceType.class.getSimpleName());
            }
        }
        if(clazz.equals(NoComplianceLevel.class)) {
            isValid = null != NoComplianceLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoComplianceLevel.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
