package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 零税率标志
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
public enum TaxRateType {

    _0("0", "非0税率"),
    _1("1", "出口退税"),
    _2("2", "免税"),
    _3("3", "不征税"),
    _4("4", "普通0税率"),
    _5("5", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxRateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRateType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
