package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_business
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceBusiness implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 组织id
   */
  private Long orgId;
  /**
   * 发票状态
   */
  private String invoiceStatus;
  /**
   * 协同标记
   */
  private String cooperateFlag;
  /**
   * 合规状态
   */
  private String complianceStatus;
  /**
   * 退票状态
   */
  private String retreatStatus;
  /**
   * 退票备注
   */
  private String retreatRemark;
  /**
   * 挂起状态
   */
  private String hangStatus;
  /**
   * 挂起原因
   */
  private String hangRemark;
  /**
   * 签收状态
   */
  private String signForStatus;
  /**
   * 签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signForTime;
  /**
   * 记账状态
   */
  private String chargeUpStatus;
  /**
   * 记账日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime chargeUpPeriod;
  /**
   * 记账单号
   */
  private String chargeUpNo;
  /**
   * 付款状态
   */
  private String paymentStatus;
  /**
   * 付款单号
   */
  private String paymentNo;
  /**
   * 付款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;
  /**
   * 失信状态
   */
  private String blackStatus;
  /**
   * 失信原因
   */
  private String blackRemark;
  /**
   * 进转出状态
   */
  private String turnOutStatus;
  /**
   * 进转出类型
   */
  private String turnOutType;
  /**
   * 进转出金额
   */
  private String turnOutAmount;
  /**
   * 进转出日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime turnOutPeriod;
  /**
   * 审核状态
   */
  private String auditStatus;
  /**
   * 审核人
   */
  private String auditName;
  /**
   * 审核备注
   */
  private String auditRemark;
  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;
  /**
   * 被红冲不含税金额
   */
  private String reserveAmountWithoutTax;
  /**
   * 被红冲税额
   */
  private String reserveTaxAmount;
  /**
   * 被红冲含税金额
   */
  private String reserveAmountWithTax;
  /**
   * 数据状态
   */
  private String dataStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 发票来源
   */
  private String invoiceOrig;
  /**
   * 公司ID
   */
  private Long purchaserCompanyId;
  /**
   * 公司编号
   */
  private String purchaserNo;
  /**
   * 发票业务类型
   */
  private String invoiceBusinessType;
  /**
   * 匹配状态
   */
  private String matchStatus;
  /**
   * 识别状态
   */
  private String recogStatus;

  /**
   * 对一关联关系 关联对象 invoiceMain
   */
  private Long businessAndInvoiceMainRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("invoice_status", invoiceStatus);
      map.put("cooperate_flag", cooperateFlag);
      map.put("compliance_status", complianceStatus);
      map.put("retreat_status", retreatStatus);
      map.put("retreat_remark", retreatRemark);
      map.put("hang_status", hangStatus);
      map.put("hang_remark", hangRemark);
      map.put("sign_for_status", signForStatus);
      map.put("sign_for_time", BocpGenUtils.toTimestamp(signForTime));
      map.put("charge_up_status", chargeUpStatus);
      map.put("charge_up_period", BocpGenUtils.toTimestamp(chargeUpPeriod));
      map.put("charge_up_no", chargeUpNo);
      map.put("payment_status", paymentStatus);
      map.put("payment_no", paymentNo);
      map.put("payment_date", BocpGenUtils.toTimestamp(paymentDate));
      map.put("black_status", blackStatus);
      map.put("black_remark", blackRemark);
      map.put("turn_out_status", turnOutStatus);
      map.put("turn_out_type", turnOutType);
      map.put("turn_out_amount", turnOutAmount);
      map.put("turn_out_period", BocpGenUtils.toTimestamp(turnOutPeriod));
      map.put("audit_status", auditStatus);
      map.put("audit_name", auditName);
      map.put("audit_remark", auditRemark);
      map.put("audit_time", BocpGenUtils.toTimestamp(auditTime));
      map.put("reserve_amount_without_tax", reserveAmountWithoutTax);
      map.put("reserve_tax_amount", reserveTaxAmount);
      map.put("reserve_amount_with_tax", reserveAmountWithTax);
      map.put("data_status", dataStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoice_orig", invoiceOrig);
      map.put("purchaser_company_id", purchaserCompanyId);
      map.put("purchaser_no", purchaserNo);
      map.put("invoice_business_type", invoiceBusinessType);
      map.put("match_status", matchStatus);
      map.put("recog_status", recogStatus);

      map.put("businessAndInvoiceMainRelation.id", businessAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceBusiness fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceBusiness entity = new InvoiceBusiness();

    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignForTime(null);
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setChargeUpPeriod(null);
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBlackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBlackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_type")) {
      Object obj = map.get("turn_out_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTurnOutPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTurnOutPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTurnOutPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTurnOutPeriod(null);
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserveAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserveTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserveAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("businessAndInvoiceMainRelation.id")) {
       Object obj = map.get("businessAndInvoiceMainRelation.id");
       if(obj instanceof Long) {
         entity.setBusinessAndInvoiceMainRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setBusinessAndInvoiceMainRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setCooperateFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setComplianceStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRetreatRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setHangStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setHangRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setSignForStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSignForTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSignForTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSignForTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSignForTime(null);
      }
   }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUpStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setChargeUpPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setChargeUpPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setChargeUpPeriod(null);
      }
   }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUpNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setPaymentDate(null);
      }
   }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setBlackStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setBlackRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setTurnOutStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_type")) {
      Object obj = map.get("turn_out_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setTurnOutType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTurnOutAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTurnOutPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTurnOutPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setTurnOutPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTurnOutPeriod(null);
      }
   }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuditTime(null);
      }
   }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserveAmountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserveTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserveAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setDataStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPurchaserCompanyId((Long)obj);
        } else if(obj instanceof String) {
            this.setPurchaserCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPurchaserCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setMatchStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setRecogStatus((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("businessAndInvoiceMainRelation.id")) {
    Object obj = map.get("businessAndInvoiceMainRelation.id");
    if(obj instanceof Long) {
        this.setBusinessAndInvoiceMainRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setBusinessAndInvoiceMainRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
