package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_item
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceItem implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 货物或应税劳务代码
   */
  private String cargoCode;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 货物或应税劳务名称
   */
  private String cargoName;
  /**
   * 规格型号
   */
  private String itemSpec;
  /**
   * 单位
   */
  private String quantityUnit;
  /**
   * 数量
   */
  private String quantity;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 单价
   */
  private String unitPrice;
  /**
   * 税额
   */
  private String taxAmount;
  /**
   * 不含税金额
   */
  private String amountWithoutTax;
  /**
   * 含税金额
   */
  private String amountWithTax;
  /**
   * 零税率标志
   */
  private String taxRateType;
  /**
   * 通行日期起
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tollStartDate;
  /**
   * 通行日期止
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tollEndDate;
  /**
   * 车牌号
   */
  private String plateNumber;
  /**
   * 车辆类型
   */
  private String vehicleType;
  /**
   * 不含税折扣金额
   */
  private String discountWithoutTax;
  /**
   * 折扣税额
   */
  private String discountTax;
  /**
   * 含税折扣金额
   */
  private String discountWithTax;
  /**
   * 折扣率
   */
  private String discountRate;
  /**
   * 商品税目
   */
  private String taxItem;
  /**
   * 税编版本号
   */
  private String goodsNoVer;
  /**
   * 税收分类编码
   */
  private String goodsTaxNo;
  /**
   * 商品编号
   */
  private String goodsErpNo;
  /**
   * 税收优惠政策
   */
  private String taxPreFlag;
  /**
   * 享受税收优惠政策内容
   */
  private String taxPreContent;
  /**
   * 扣除额
   */
  private String taxDedunction;
  /**
   * 折扣行标志
   */
  private String discountFlag;
  /**
   * 价格方式
   */
  private String priceMethod;
  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 对一关联关系 关联对象 invoiceView
   */
  private Long invoiceItemAndInvoiceViewRelationId;
  /**
   * 对一关联关系 关联对象 invoiceMain
   */
  private Long invoiceItemAndInvoiceMainRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_code", invoiceCode);
      map.put("invoice_no", invoiceNo);
      map.put("cargo_code", cargoCode);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("cargo_name", cargoName);
      map.put("item_spec", itemSpec);
      map.put("quantity_unit", quantityUnit);
      map.put("quantity", quantity);
      map.put("tax_rate", taxRate);
      map.put("unit_price", unitPrice);
      map.put("tax_amount", taxAmount);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_rate_type", taxRateType);
      map.put("toll_start_date", BocpGenUtils.toTimestamp(tollStartDate));
      map.put("toll_end_date", BocpGenUtils.toTimestamp(tollEndDate));
      map.put("plate_number", plateNumber);
      map.put("vehicle_type", vehicleType);
      map.put("discount_without_tax", discountWithoutTax);
      map.put("discount_tax", discountTax);
      map.put("discount_with_tax", discountWithTax);
      map.put("discount_rate", discountRate);
      map.put("tax_item", taxItem);
      map.put("goods_no_ver", goodsNoVer);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("goods_erp_no", goodsErpNo);
      map.put("tax_pre_flag", taxPreFlag);
      map.put("tax_pre_content", taxPreContent);
      map.put("tax_dedunction", taxDedunction);
      map.put("discount_flag", discountFlag);
      map.put("price_method", priceMethod);
      map.put("org_id", orgId);

      map.put("invoiceItemAndInvoiceViewRelation.id", invoiceItemAndInvoiceViewRelationId);
      map.put("invoiceItemAndInvoiceMainRelation.id", invoiceItemAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceItem fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceItem entity = new InvoiceItem();

    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargo_code")) {
      Object obj = map.get("cargo_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cargo_name")) {
      Object obj = map.get("cargo_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCargoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate_type")) {
      Object obj = map.get("tax_rate_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxRateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toll_start_date")) {
      Object obj = map.get("toll_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTollStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTollStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTollStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTollStartDate(null);
      }
    }
    if(map.containsKey("toll_end_date")) {
      Object obj = map.get("toll_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTollEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTollEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTollEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTollEndDate(null);
      }
    }
    if(map.containsKey("plate_number")) {
      Object obj = map.get("plate_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlateNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehicleType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_without_tax")) {
      Object obj = map.get("discount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_tax")) {
      Object obj = map.get("discount_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_with_tax")) {
      Object obj = map.get("discount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_rate")) {
      Object obj = map.get("discount_rate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_item")) {
      Object obj = map.get("tax_item");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_no_ver")) {
      Object obj = map.get("goods_no_ver");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsNoVer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_erp_no")) {
      Object obj = map.get("goods_erp_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsErpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_flag")) {
      Object obj = map.get("tax_pre_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_pre_content")) {
      Object obj = map.get("tax_pre_content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPreContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_dedunction")) {
      Object obj = map.get("tax_dedunction");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxDedunction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount_flag")) {
      Object obj = map.get("discount_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscountFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    if(map.containsKey("invoiceItemAndInvoiceViewRelation.id")) {
       Object obj = map.get("invoiceItemAndInvoiceViewRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceItemAndInvoiceViewRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceItemAndInvoiceViewRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("invoiceItemAndInvoiceMainRelation.id")) {
       Object obj = map.get("invoiceItemAndInvoiceMainRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceItemAndInvoiceMainRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceItemAndInvoiceMainRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cargo_code")) {
      Object obj = map.get("cargo_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setCargoCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cargo_name")) {
      Object obj = map.get("cargo_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCargoName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String){
            this.setItemSpec((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantityUnit((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String){
            this.setQuantity((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnitPrice((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_rate_type")) {
      Object obj = map.get("tax_rate_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxRateType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("toll_start_date")) {
      Object obj = map.get("toll_start_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTollStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTollStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setTollStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTollStartDate(null);
      }
   }
    if(map.containsKey("toll_end_date")) {
      Object obj = map.get("toll_end_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTollEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setTollEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setTollEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setTollEndDate(null);
      }
   }
    if(map.containsKey("plate_number")) {
      Object obj = map.get("plate_number");
      if(obj != null) {
        if(obj instanceof String){
            this.setPlateNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("vehicle_type")) {
      Object obj = map.get("vehicle_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setVehicleType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discount_without_tax")) {
      Object obj = map.get("discount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discount_tax")) {
      Object obj = map.get("discount_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discount_with_tax")) {
      Object obj = map.get("discount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discount_rate")) {
      Object obj = map.get("discount_rate");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountRate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_item")) {
      Object obj = map.get("tax_item");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxItem((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goods_no_ver")) {
      Object obj = map.get("goods_no_ver");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsNoVer((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goods_erp_no")) {
      Object obj = map.get("goods_erp_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsErpNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_pre_flag")) {
      Object obj = map.get("tax_pre_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPreFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_pre_content")) {
      Object obj = map.get("tax_pre_content");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPreContent((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_dedunction")) {
      Object obj = map.get("tax_dedunction");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxDedunction((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("discount_flag")) {
      Object obj = map.get("discount_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDiscountFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String){
            this.setPriceMethod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }

  if(map.containsKey("invoiceItemAndInvoiceViewRelation.id")) {
    Object obj = map.get("invoiceItemAndInvoiceViewRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceItemAndInvoiceViewRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceItemAndInvoiceViewRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("invoiceItemAndInvoiceMainRelation.id")) {
    Object obj = map.get("invoiceItemAndInvoiceMainRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceItemAndInvoiceMainRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceItemAndInvoiceMainRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
