package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_match
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMatch implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 业务单号
   */
  private String businessOrderNo;
  /**
   * 业务单号来源
   */
  private String businessOrderOrigin;
  /**
   * 发票匹配状态
   */
  private String matchStatus;
  /**
   * 配单人姓名
   */
  private String matchUserName;
  /**
   * 配单人id
   */
  private Long matchUserId;
  /**
   * 匹配金额
   */
  private String matchAmount;
  /**
   * 配单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime matchTime;
  /**
   * 数据状态
   */
  private String dataStatus;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 组织id
   */
  private Long orgId;

  /**
   * 对一关联关系 关联对象 invoiceMain
   */
  private Long matchAndInvoiceMainRelationId;
  /**
   * 对一关联关系 关联对象 invoiceView
   */
  private Long matchAndInvoiceViewRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("business_order_no", businessOrderNo);
      map.put("business_order_origin", businessOrderOrigin);
      map.put("match_status", matchStatus);
      map.put("match_user_name", matchUserName);
      map.put("match_user_id", matchUserId);
      map.put("match_amount", matchAmount);
      map.put("match_time", BocpGenUtils.toTimestamp(matchTime));
      map.put("data_status", dataStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_id", orgId);

      map.put("matchAndInvoiceMainRelation.id", matchAndInvoiceMainRelationId);
      map.put("matchAndInvoiceViewRelation.id", matchAndInvoiceViewRelationId);
      return map;
  }

  public static InvoiceMatch fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMatch entity = new InvoiceMatch();

    if(map.containsKey("business_order_no")) {
      Object obj = map.get("business_order_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_order_origin")) {
      Object obj = map.get("business_order_origin");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessOrderOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_user_name")) {
      Object obj = map.get("match_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_user_id")) {
      Object obj = map.get("match_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setMatchUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMatchUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("match_amount")) {
      Object obj = map.get("match_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_time")) {
      Object obj = map.get("match_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMatchTime(null);
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    if(map.containsKey("matchAndInvoiceMainRelation.id")) {
       Object obj = map.get("matchAndInvoiceMainRelation.id");
       if(obj instanceof Long) {
         entity.setMatchAndInvoiceMainRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setMatchAndInvoiceMainRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("matchAndInvoiceViewRelation.id")) {
       Object obj = map.get("matchAndInvoiceViewRelation.id");
       if(obj instanceof Long) {
         entity.setMatchAndInvoiceViewRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setMatchAndInvoiceViewRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("business_order_no")) {
      Object obj = map.get("business_order_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessOrderNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("business_order_origin")) {
      Object obj = map.get("business_order_origin");
      if(obj != null) {
        if(obj instanceof String){
            this.setBusinessOrderOrigin((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setMatchStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("match_user_name")) {
      Object obj = map.get("match_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setMatchUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("match_user_id")) {
      Object obj = map.get("match_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMatchUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setMatchUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setMatchUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("match_amount")) {
      Object obj = map.get("match_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setMatchAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("match_time")) {
      Object obj = map.get("match_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setMatchTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setMatchTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setMatchTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setMatchTime(null);
      }
   }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setDataStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }

  if(map.containsKey("matchAndInvoiceMainRelation.id")) {
    Object obj = map.get("matchAndInvoiceMainRelation.id");
    if(obj instanceof Long) {
        this.setMatchAndInvoiceMainRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setMatchAndInvoiceMainRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("matchAndInvoiceViewRelation.id")) {
    Object obj = map.get("matchAndInvoiceViewRelation.id");
    if(obj instanceof Long) {
        this.setMatchAndInvoiceViewRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setMatchAndInvoiceViewRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
