package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_view
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceView implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 勾选人id
   */
  private String checkUserId;
  /**
   * 勾选人名称
   */
  private String checkUserName;
  /**
   * 勾选时间
   */
  private String checkTime;
  /**
   * 认证方式
   */
  private String authStyle;
  /**
   * 抵扣用途
   */
  private String authUse;
  /**
   * 认证备注
   */
  private String authRemark;
  /**
   * 认证状态
   */
  private String authStatus;
  /**
   * 可抵扣税额
   */
  private String effectiveTaxAmount;
  /**
   * 不抵扣原因
   */
  private String noAuthReason;
  /**
   * 底账确认日期
   */
  private String authBussiDate;
  /**
   * 税款所属期
   */
  private String authTaxPeriod;
  /**
   * 发票状态
   */
  private String invoiceStatus;
  /**
   * 发票来源
   */
  private String invoiceOrig;
  /**
   * 协同标记
   */
  private String cooperateFlag;
  /**
   * 合规状态
   */
  private String complianceStatus;
  /**
   * 退票状态
   */
  private String retreatStatus;
  /**
   * 退票备注
   */
  private String retreatRemark;
  /**
   * 挂起状态
   */
  private String hangStatus;
  /**
   * 挂起原因
   */
  private String hangRemark;
  /**
   * 签收状态
   */
  private String signForStatus;
  /**
   * 签收时间
   */
  private String signForTime;
  /**
   * 记账状态
   */
  private String chargeUpStatus;
  /**
   * 记账日期
   */
  private String chargeUpPeriod;
  /**
   * 记账单号
   */
  private String chargeUpNo;
  /**
   * 付款状态
   */
  private String paymentStatus;
  /**
   * 付款单号
   */
  private String paymentNo;
  /**
   * 付款日期
   */
  private String paymentDate;
  /**
   * 失信状态
   */
  private String blackStatus;
  /**
   * 失信原因
   */
  private String blackRemark;
  /**
   * 进转出状态
   */
  private String turnOutStatus;
  /**
   * 进转出金额
   */
  private String turnOutAmount;
  /**
   * 进转出日期
   */
  private String turnOutPeriod;
  /**
   * 审核状态
   */
  private String auditStatus;
  /**
   * 审核人
   */
  private String auditName;
  /**
   * 审核备注
   */
  private String auditRemark;
  /**
   * 审核时间
   */
  private String auditTime;
  /**
   * 被红冲不含税金额
   */
  private String reserveAmountWithoutTax;
  /**
   * 被红冲税额
   */
  private String reserveTaxAmount;
  /**
   * 被红冲含税金额
   */
  private String reserveAmountWithTax;
  /**
   * 开票日期
   */
  private String paperDrewDate;
  /**
   * 不含税金额
   */
  private String amountWithoutTax;
  /**
   * 税额
   */
  private String taxAmount;
  /**
   * 含税金额
   */
  private String amountWithTax;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 销方名称
   */
  private String sellerName;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 机器编码
   */
  private String machineCode;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 收款人姓名
   */
  private String cashierName;
  /**
   * 复核人姓名
   */
  private String checkerName;
  /**
   * 开票人姓名
   */
  private String invoicerName;
  /**
   * 购方地址电话
   */
  private String purchaserAddrTel;
  /**
   * 购方开户行及账号
   */
  private String purchaserBankNameAccount;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 销方开户行及账号
   */
  private String sellerBankNameAccount;
  /**
   * 发票备注
   */
  private String invoiceRemark;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 代开标记
   */
  private String issueFlag;
  /**
   * 代开名称
   */
  private String issueName;
  /**
   * 代开税号
   */
  private String issueTaxNo;
  /**
   * 特殊发票标记
   */
  private String specialInvoiceFlag;
  /**
   * 源文件地址
   */
  private String originFileUrl;
  /**
   * 源文件类型
   */
  private String originFileType;
  /**
   * 租户名称
   */
  private String tenantName;
  /**
   * 是否有销货清单
   */
  private String saleListFlag;
  /**
   * 地区代码
   */
  private String areaCode;
  /**
   * 地区名称
   */
  private String areaName;
  /**
   * 组织id
   */
  private String orgId;
  /**
   * 验真人id
   */
  private String verifyUserId;
  /**
   * 验真人姓名
   */
  private String verifyUserName;
  /**
   * 验真时间
   */
  private String verifyTime;
  /**
   * 验真次数
   */
  private String verifyNumber;
  /**
   * 验真备注
   */
  private String verifyRemark;
  /**
   * 验真状态
   */
  private String verifyStatus;
  /**
   * 验签状态
   */
  private String verifySignStatus;
  /**
   * 税件验真任务id
   */
  private String taxTaskId;
  /**
   * 数据状态
   */
  private String dataStatus;
  /**
   * 红蓝标识
   */
  private String invoiceColor;
  /**
   * 公司ID
   */
  private String purchaserCompanyId;
  /**
   * 公司编号
   */
  private String purchaserNo;
  /**
   * 发票业务类型
   */
  private String invoiceBusinessType;
  /**
   * 识别状态
   */
  private String recogStatus;
  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 对一关联关系 关联对象 invoiceMain
   */
  private Long invoiceViewAndInvoiceMainRelationId;
  /**
   * 对一关联关系 关联对象 invoiceVerify
   */
  private Long invoiceViewAndInvoiceVerifyRelationId;
  /**
   * 对一关联关系 关联对象 invoiceAuth
   */
  private Long invoiceViewAndInvoiceAuthRelationId;
  /**
   * 对一关联关系 关联对象 invoiceBusiness
   */
  private Long invoiceViewAndInvoiceBusinessRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_type", invoiceType);
      map.put("check_user_id", checkUserId);
      map.put("check_user_name", checkUserName);
      map.put("check_time", checkTime);
      map.put("auth_style", authStyle);
      map.put("auth_use", authUse);
      map.put("auth_remark", authRemark);
      map.put("auth_status", authStatus);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("no_auth_reason", noAuthReason);
      map.put("auth_bussi_date", authBussiDate);
      map.put("auth_tax_period", authTaxPeriod);
      map.put("invoice_status", invoiceStatus);
      map.put("invoice_orig", invoiceOrig);
      map.put("cooperate_flag", cooperateFlag);
      map.put("compliance_status", complianceStatus);
      map.put("retreat_status", retreatStatus);
      map.put("retreat_remark", retreatRemark);
      map.put("hang_status", hangStatus);
      map.put("hang_remark", hangRemark);
      map.put("sign_for_status", signForStatus);
      map.put("sign_for_time", signForTime);
      map.put("charge_up_status", chargeUpStatus);
      map.put("charge_up_period", chargeUpPeriod);
      map.put("charge_up_no", chargeUpNo);
      map.put("payment_status", paymentStatus);
      map.put("payment_no", paymentNo);
      map.put("payment_date", paymentDate);
      map.put("black_status", blackStatus);
      map.put("black_remark", blackRemark);
      map.put("turn_out_status", turnOutStatus);
      map.put("turn_out_amount", turnOutAmount);
      map.put("turn_out_period", turnOutPeriod);
      map.put("audit_status", auditStatus);
      map.put("audit_name", auditName);
      map.put("audit_remark", auditRemark);
      map.put("audit_time", auditTime);
      map.put("reserve_amount_without_tax", reserveAmountWithoutTax);
      map.put("reserve_tax_amount", reserveTaxAmount);
      map.put("reserve_amount_with_tax", reserveAmountWithTax);
      map.put("paper_drew_date", paperDrewDate);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("amount_with_tax", amountWithTax);
      map.put("purchaser_name", purchaserName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("machine_code", machineCode);
      map.put("check_code", checkCode);
      map.put("cipher_text", cipherText);
      map.put("cashier_name", cashierName);
      map.put("checker_name", checkerName);
      map.put("invoicer_name", invoicerName);
      map.put("purchaser_addr_tel", purchaserAddrTel);
      map.put("purchaser_bank_name_account", purchaserBankNameAccount);
      map.put("seller_addr_tel", sellerAddrTel);
      map.put("seller_bank_name_account", sellerBankNameAccount);
      map.put("invoice_remark", invoiceRemark);
      map.put("origin_invoice_no", originInvoiceNo);
      map.put("origin_invoice_code", originInvoiceCode);
      map.put("issue_flag", issueFlag);
      map.put("issue_name", issueName);
      map.put("issue_tax_no", issueTaxNo);
      map.put("special_invoice_flag", specialInvoiceFlag);
      map.put("origin_file_url", originFileUrl);
      map.put("origin_file_type", originFileType);
      map.put("tenant_name", tenantName);
      map.put("sale_list_flag", saleListFlag);
      map.put("area_code", areaCode);
      map.put("area_name", areaName);
      map.put("org_id", orgId);
      map.put("verify_user_id", verifyUserId);
      map.put("verify_user_name", verifyUserName);
      map.put("verify_time", verifyTime);
      map.put("verify_number", verifyNumber);
      map.put("verify_remark", verifyRemark);
      map.put("verify_status", verifyStatus);
      map.put("verify_sign_status", verifySignStatus);
      map.put("tax_task_id", taxTaskId);
      map.put("data_status", dataStatus);
      map.put("invoice_color", invoiceColor);
      map.put("purchaser_company_id", purchaserCompanyId);
      map.put("purchaser_no", purchaserNo);
      map.put("invoice_business_type", invoiceBusinessType);
      map.put("recog_status", recogStatus);
      map.put("match_status", matchStatus);

      map.put("invoiceViewAndInvoiceMainRelation.id", invoiceViewAndInvoiceMainRelationId);
      map.put("invoiceViewAndInvoiceVerifyRelation.id", invoiceViewAndInvoiceVerifyRelationId);
      map.put("invoiceViewAndInvoiceAuthRelation.id", invoiceViewAndInvoiceAuthRelationId);
      map.put("invoiceViewAndInvoiceBusinessRelation.id", invoiceViewAndInvoiceBusinessRelationId);
      return map;
  }

  public static InvoiceView fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceView entity = new InvoiceView();

    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEffectiveTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthBussiDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCooperateFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComplianceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRetreatRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHangRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignForStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSignForTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChargeUpNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBlackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBlackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTurnOutPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuditTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserveAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserveTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReserveAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMachineCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_remark")) {
      Object obj = map.get("invoice_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issue_flag")) {
      Object obj = map.get("issue_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssueFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issue_name")) {
      Object obj = map.get("issue_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssueName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issue_tax_no")) {
      Object obj = map.get("issue_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIssueTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_file_url")) {
      Object obj = map.get("origin_file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_file_type")) {
      Object obj = map.get("origin_file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sale_list_flag")) {
      Object obj = map.get("sale_list_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSaleListFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAreaCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAreaName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVerifySignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxTaskId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserCompanyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("invoiceViewAndInvoiceMainRelation.id")) {
       Object obj = map.get("invoiceViewAndInvoiceMainRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceViewAndInvoiceMainRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceViewAndInvoiceMainRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("invoiceViewAndInvoiceVerifyRelation.id")) {
       Object obj = map.get("invoiceViewAndInvoiceVerifyRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceViewAndInvoiceVerifyRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceViewAndInvoiceVerifyRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("invoiceViewAndInvoiceAuthRelation.id")) {
       Object obj = map.get("invoiceViewAndInvoiceAuthRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceViewAndInvoiceAuthRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceViewAndInvoiceAuthRelationId(Long.parseLong((String)obj));
       }
    }
    if(map.containsKey("invoiceViewAndInvoiceBusinessRelation.id")) {
       Object obj = map.get("invoiceViewAndInvoiceBusinessRelation.id");
       if(obj instanceof Long) {
         entity.setInvoiceViewAndInvoiceBusinessRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setInvoiceViewAndInvoiceBusinessRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckUserId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthStyle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthUse((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setEffectiveTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String){
            this.setNoAuthReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthBussiDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthTaxPeriod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_orig")) {
      Object obj = map.get("invoice_orig");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceOrig((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cooperate_flag")) {
      Object obj = map.get("cooperate_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setCooperateFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("compliance_status")) {
      Object obj = map.get("compliance_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setComplianceStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreat_status")) {
      Object obj = map.get("retreat_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("retreat_remark")) {
      Object obj = map.get("retreat_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRetreatRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hang_status")) {
      Object obj = map.get("hang_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setHangStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("hang_remark")) {
      Object obj = map.get("hang_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setHangRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sign_for_status")) {
      Object obj = map.get("sign_for_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setSignForStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sign_for_time")) {
      Object obj = map.get("sign_for_time");
      if(obj != null) {
        if(obj instanceof String){
            this.setSignForTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("charge_up_status")) {
      Object obj = map.get("charge_up_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUpStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("charge_up_period")) {
      Object obj = map.get("charge_up_period");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUpPeriod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("charge_up_no")) {
      Object obj = map.get("charge_up_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setChargeUpNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_status")) {
      Object obj = map.get("payment_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_no")) {
      Object obj = map.get("payment_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payment_date")) {
      Object obj = map.get("payment_date");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaymentDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("black_status")) {
      Object obj = map.get("black_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setBlackStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("black_remark")) {
      Object obj = map.get("black_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setBlackRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_status")) {
      Object obj = map.get("turn_out_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setTurnOutStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_amount")) {
      Object obj = map.get("turn_out_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTurnOutAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("turn_out_period")) {
      Object obj = map.get("turn_out_period");
      if(obj != null) {
        if(obj instanceof String){
            this.setTurnOutPeriod((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_name")) {
      Object obj = map.get("audit_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuditTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserve_amount_without_tax")) {
      Object obj = map.get("reserve_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserveAmountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserve_tax_amount")) {
      Object obj = map.get("reserve_tax_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserveTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("reserve_amount_with_tax")) {
      Object obj = map.get("reserve_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setReserveAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
            this.setPaperDrewDate((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithoutTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountWithTax((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("machine_code")) {
      Object obj = map.get("machine_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setMachineCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("check_code")) {
      Object obj = map.get("check_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cipher_text")) {
      Object obj = map.get("cipher_text");
      if(obj != null) {
        if(obj instanceof String){
            this.setCipherText((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("cashier_name")) {
      Object obj = map.get("cashier_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCashierName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("checker_name")) {
      Object obj = map.get("checker_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoicer_name")) {
      Object obj = map.get("invoicer_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_addr_tel")) {
      Object obj = map.get("purchaser_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_bank_name_account")) {
      Object obj = map.get("purchaser_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_addr_tel")) {
      Object obj = map.get("seller_addr_tel");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("seller_bank_name_account")) {
      Object obj = map.get("seller_bank_name_account");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankNameAccount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_remark")) {
      Object obj = map.get("invoice_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_invoice_no")) {
      Object obj = map.get("origin_invoice_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_invoice_code")) {
      Object obj = map.get("origin_invoice_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("issue_flag")) {
      Object obj = map.get("issue_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setIssueFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("issue_name")) {
      Object obj = map.get("issue_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setIssueName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("issue_tax_no")) {
      Object obj = map.get("issue_tax_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setIssueTaxNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("special_invoice_flag")) {
      Object obj = map.get("special_invoice_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setSpecialInvoiceFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_file_url")) {
      Object obj = map.get("origin_file_url");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginFileUrl((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("origin_file_type")) {
      Object obj = map.get("origin_file_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setOriginFileType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tenant_name")) {
      Object obj = map.get("tenant_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("sale_list_flag")) {
      Object obj = map.get("sale_list_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setSaleListFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("area_code")) {
      Object obj = map.get("area_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setAreaCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("area_name")) {
      Object obj = map.get("area_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setAreaName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrgId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_user_id")) {
      Object obj = map.get("verify_user_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyUserId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_user_name")) {
      Object obj = map.get("verify_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyTime((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_number")) {
      Object obj = map.get("verify_number");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyNumber((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_remark")) {
      Object obj = map.get("verify_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifyStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("verify_sign_status")) {
      Object obj = map.get("verify_sign_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setVerifySignStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tax_task_id")) {
      Object obj = map.get("tax_task_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxTaskId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setDataStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceColor((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_company_id")) {
      Object obj = map.get("purchaser_company_id");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserCompanyId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("invoice_business_type")) {
      Object obj = map.get("invoice_business_type");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceBusinessType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("recog_status")) {
      Object obj = map.get("recog_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setRecogStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setMatchStatus((String)obj);
        }
      } else{
      }
   }

  if(map.containsKey("invoiceViewAndInvoiceMainRelation.id")) {
    Object obj = map.get("invoiceViewAndInvoiceMainRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceViewAndInvoiceMainRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceViewAndInvoiceMainRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("invoiceViewAndInvoiceVerifyRelation.id")) {
    Object obj = map.get("invoiceViewAndInvoiceVerifyRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceViewAndInvoiceVerifyRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceViewAndInvoiceVerifyRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("invoiceViewAndInvoiceAuthRelation.id")) {
    Object obj = map.get("invoiceViewAndInvoiceAuthRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceViewAndInvoiceAuthRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceViewAndInvoiceAuthRelationId(Long.parseLong((String)obj));
    }
  }
  if(map.containsKey("invoiceViewAndInvoiceBusinessRelation.id")) {
    Object obj = map.get("invoiceViewAndInvoiceBusinessRelation.id");
    if(obj instanceof Long) {
        this.setInvoiceViewAndInvoiceBusinessRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setInvoiceViewAndInvoiceBusinessRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
