package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 入账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum EntryStatus {

    _02("02", "已入账（企业所得税税前扣除）"),
    _03("03", "已入账（企业所得税不扣除）"),
    _06("06", "入账撤销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EntryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EntryStatus fromCode(String code) {
        return Stream.of(EntryStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
