package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件来源
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum FileOrigin {

    _0("0", "无"),
    _1("1", "采集来源"),
    _2("2", "验真来源"),
    _3("3", "协同来源"),
    _4("4", "接口来源"),
    _5("5", "页面上传");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FileOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileOrigin fromCode(String code) {
        return Stream.of(FileOrigin.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
