package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票业务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum InvoiceBusinessType {

    _0("0", "无"),
    _1("1", "费用类发票"),
    _2("2", "采购类发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceBusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceBusinessType fromCode(String code) {
        return Stream.of(InvoiceBusinessType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
