package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票扩展字段35
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum InvoiceExt35 {

    _0("0", "默认"),
    _1("1", "不可认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceExt35(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceExt35 fromCode(String code) {
        return Stream.of(InvoiceExt35.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
