package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 农产品处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum NcpHandleStatus {

    _0("0", "未处理"),
    _1("1", "处理中"),
    _2("2", "处理成功"),
    _3("3", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpHandleStatus fromCode(String code) {
        return Stream.of(NcpHandleStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
