package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 加计扣除提交状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum NcpJjkcSubmitStatus {

    _0("0", "未提交"),
    _1("1", "提交中"),
    _2("2", "提交失败"),
    _3("3", "提交成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpJjkcSubmitStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpJjkcSubmitStatus fromCode(String code) {
        return Stream.of(NcpJjkcSubmitStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
