package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 农产品操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum NcpOperateType {

    _0("0", "无"),
    _1("1", "农产品处理类型"),
    _2("2", "代开农产品发票录入"),
    _3("3", "农产品发票加计扣除"),
    _4("4", "农产品缴款书加计扣除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpOperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpOperateType fromCode(String code) {
        return Stream.of(NcpOperateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
