package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 不合规等级
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum NoComplianceLevel {

    _0("0", "无"),
    _1("1", "弱控"),
    _2("2", "强控");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoComplianceLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoComplianceLevel fromCode(String code) {
        return Stream.of(NoComplianceLevel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
