package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 风险发票类别
 * </p>
 *
 * @author ultraman
 * @since 2023-07-05
 */
public enum RiskInvoiceCategory {

    _0("0", "风险发票"),
    _1("1", "预警发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RiskInvoiceCategory(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RiskInvoiceCategory fromCode(String code) {
        return Stream.of(RiskInvoiceCategory.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
