package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 记账状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum ChargeUpStatus {

    _0("0", "未记账"),
    _1("1", "已记账"),
    _2("2", "记账失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeUpStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeUpStatus fromCode(String code) {
        return Stream.of(ChargeUpStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
