package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 锁定状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum HangStatus {

    _0("0", "未锁定"),
    _1("1", "已锁定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HangStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HangStatus fromCode(String code) {
        return Stream.of(HangStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
