package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 匹配状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum MatchStatus {

    _0("0", "未匹配"),
    _1("1", "匹配中"),
    _2("2", "已匹配"),
    _3("3", "有冲突"),
    _4("4", "待确认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchStatus fromCode(String code) {
        return Stream.of(MatchStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
