package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 加计扣除状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum NcpJjkcStatus {

    _0("0", "未加计扣除"),
    _1("1", "部分加计扣除"),
    _2("2", "完成加计扣除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpJjkcStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpJjkcStatus fromCode(String code) {
        return Stream.of(NcpJjkcStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
