package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 报销状态
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum ReimbursementStatus {

    _0("0", "未报销"),
    _1("1", "报销中"),
    _2("2", "已报销"),
    _3("3", "报销异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReimbursementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReimbursementStatus fromCode(String code) {
        return Stream.of(ReimbursementStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
