package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 税收优惠政策类型代码
 * </p>
 *
 * @author ultraman
 * @since 2023-07-18
 */
public enum TaxIncentivesType {

    _01("01", "简易征收"),
    _00("00", "非税收优惠政策"),
    _02("02", "稀土产品"),
    _03("03", "免税"),
    _04("04", "不征税"),
    _05("05", "先征后退"),
    _06("06", "100%先征后退"),
    _07("07", "50%先征后退"),
    _08("08", "按3%简易征收"),
    _09("09", "按5%简易征收"),
    _10("10", "按5%简易征收减按1.5%计征"),
    _11("11", "即征即退30%"),
    _12("12", "即征即退50%"),
    _13("13", "即征即退70%"),
    _14("14", "即征即退100%"),
    _15("15", "超税负3%即征即退"),
    _16("16", "超税负8%即征即退"),
    _17("17", "超税负12%即征即退"),
    _18("18", "超税负6%即征即退");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxIncentivesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxIncentivesType fromCode(String code) {
        return Stream.of(TaxIncentivesType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
