package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 不抵扣原因
 * </p>
 *
 * @author ultraman
 * @since 2022-06-21
 */
public enum NoAuthReason {

    _1("1", "用于非应税项目"),
    _2("2", "用于免税项目"),
    _3("3", "用户集体福利或者个人消费"),
    _4("4", "遭受非正常损失"),
    _5("5", "其他"),
    _0("0", "无");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoAuthReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoAuthReason fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
