package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_auth
 * </p>
 *
 * @author ultraman
 * @since 2022-06-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceAuth implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 组织id
   */
  private Long orgId;
  /**
   * 勾选人id
   */
  private Long checkUserId;
  /**
   * 勾选时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkTime;
  /**
   * 数据状态
   */
  private String dataStatus;
  /**
   * 认证方式
   */
  private String authStyle;
  /**
   * 抵扣用途
   */
  private String authUse;
  /**
   * 认证备注
   */
  private String authRemark;
  /**
   * 认证状态
   */
  private String authStatus;
  /**
   * 可抵扣税额
   */
  private BigDecimal effectiveTaxAmount;
  /**
   * 不抵扣原因
   */
  private String noAuthReason;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 勾选人名称
   */
  private String checkUserName;
  /**
   * 底账确认日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authBussiDate;
  /**
   * 税款所属期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTaxPeriod;
  /**
   * 底帐获取时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime elTime;

  /**
   * 对一关联关系 关联对象 invoiceMain
   */
  private Long authAndInvoiceMainRelationId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("org_id", orgId);
      map.put("check_user_id", checkUserId);
      map.put("check_time", BocpGenUtils.toTimestamp(checkTime));
      map.put("data_status", dataStatus);
      map.put("auth_style", authStyle);
      map.put("auth_use", authUse);
      map.put("auth_remark", authRemark);
      map.put("auth_status", authStatus);
      map.put("effective_tax_amount", effectiveTaxAmount);
      map.put("no_auth_reason", noAuthReason);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("check_user_name", checkUserName);
      map.put("auth_bussi_date", BocpGenUtils.toTimestamp(authBussiDate));
      map.put("auth_tax_period", BocpGenUtils.toTimestamp(authTaxPeriod));
      map.put("el_time", BocpGenUtils.toTimestamp(elTime));

      map.put("authAndInvoiceMainRelation.id", authAndInvoiceMainRelationId);
      return map;
  }

  public static InvoiceAuth fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceAuth entity = new InvoiceAuth();

    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckTime(null);
      }
    }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStyle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNoAuthReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthBussiDate(null);
      }
    }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTaxPeriod(null);
      }
    }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setElTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setElTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setElTime(null);
      }
    }

    if(map.containsKey("authAndInvoiceMainRelation.id")) {
       Object obj = map.get("authAndInvoiceMainRelation.id");
       if(obj instanceof Long) {
         entity.setAuthAndInvoiceMainRelationId((Long)obj);
       } else if(obj instanceof String) {
         entity.setAuthAndInvoiceMainRelationId(Long.parseLong((String)obj));
       }
    }
    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrgId((Long)obj);
        } else if(obj instanceof String) {
            this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("check_user_id")) {
      Object obj = map.get("check_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCheckUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCheckUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("check_time")) {
      Object obj = map.get("check_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCheckTime(null);
      }
   }
    if(map.containsKey("data_status")) {
      Object obj = map.get("data_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setDataStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_style")) {
      Object obj = map.get("auth_style");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthStyle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_use")) {
      Object obj = map.get("auth_use");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthUse((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_remark")) {
      Object obj = map.get("auth_remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("effective_tax_amount")) {
      Object obj = map.get("effective_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
   }
    if(map.containsKey("no_auth_reason")) {
      Object obj = map.get("no_auth_reason");
      if(obj != null) {
        if(obj instanceof String){
            this.setNoAuthReason((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("check_user_name")) {
      Object obj = map.get("check_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("auth_bussi_date")) {
      Object obj = map.get("auth_bussi_date");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthBussiDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthBussiDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAuthBussiDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthBussiDate(null);
      }
   }
    if(map.containsKey("auth_tax_period")) {
      Object obj = map.get("auth_tax_period");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setAuthTaxPeriod((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setAuthTaxPeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setAuthTaxPeriod(null);
      }
   }
    if(map.containsKey("el_time")) {
      Object obj = map.get("el_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setElTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setElTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setElTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setElTime(null);
      }
   }

  if(map.containsKey("authAndInvoiceMainRelation.id")) {
    Object obj = map.get("authAndInvoiceMainRelation.id");
    if(obj instanceof Long) {
        this.setAuthAndInvoiceMainRelationId((Long)obj);
    } else if(obj instanceof String) {
        this.setAuthAndInvoiceMainRelationId(Long.parseLong((String)obj));
    }
  }
  }

}
