package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-02
 */
public enum DataStatus {

    _1("1", "正常"),
    _2("2", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataStatus fromCode(String code) {
        return Stream.of(DataStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
