package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 折扣行标志
 * </p>
 *
 * @author ultraman
 * @since 2023-08-02
 */
public enum DiscountFlag {

    _0("0", "无"),
    _1("1", "有");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DiscountFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DiscountFlag fromCode(String code) {
        return Stream.of(DiscountFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
