package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否转交异常
 * </p>
 *
 * @author ultraman
 * @since 2023-08-02
 */
public enum IsSendException {

    _0("0", "否"),
    _1("1", "是"),
    _9("9", "已处理");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsSendException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsSendException fromCode(String code) {
        return Stream.of(IsSendException.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
