package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票业务操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-08-02
 */
public enum OperateType {

    _0("0", "未知"),
    _1("1", "农产品发票加计扣除操作"),
    _2("2", "发票退票操作"),
    _3("3", "发票影像删除操作"),
    _4("4", "发票删除操作"),
    _5("5", "手动验真操作"),
    _6("6", "风险发票手动跟进操作"),
    _7("7", "风险发票手动添加操作"),
    _8("8", "风险发票手动解除管控操作"),
    _9("9", "风险发票自动管控(退票)/自动解除管控(取消退票)操作"),
    _10("10", "发票取消退票操作"),
    _11("11", "下载影像"),
    _12("12", "修改扩展信息"),
    _13("13", "发票影像提交操作");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperateType fromCode(String code) {
        return Stream.of(OperateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
