package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 错误码
 * </p>
 *
 * @author ultraman
 * @since 2022-06-29
 */
public enum ErrorCode {

    INVALIDATE_INVOICE_CODE("invalidate_invoice_code", "无效的发票代码");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErrorCode fromCode(String code){
        switch(code) {
            case "invalidate_invoice_code":
                return INVALIDATE_INVOICE_CODE;
            default:
                return null;
        }
    }
}
