package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理状态
 * </p>
 *
 * @author ultraman
 * @since 2022-06-29
 */
public enum ProcessStatus {

    _0("0", "未处理"),
    _1("1", "处理中"),
    _2("2", "处理成功"),
    _3("3", "处理失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
