package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 区域
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum AreaType {

    HUABEI("huabei", "华北"),
    HUADONG("huadong", "华东"),
    DONGBEI("dongbei", "东北"),
    HUANAN("huanan", "华南"),
    HUAZHONG("huazhong", "华中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AreaType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AreaType fromCode(String code) {
        return Stream.of(AreaType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
