package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 失信状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum BlackStatus {

    _0("0", "正常"),
    _1("1", "系统黑名单"),
    _2("2", "国税黑名单");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BlackStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BlackStatus fromCode(String code) {
        return Stream.of(BlackStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
