package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 入账Tab栏状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum EntryTabStatus {

    _0("0", "未入账"),
    _1("1", "入账中"),
    _2("2", "已入账"),
    _3("3", "入账失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EntryTabStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EntryTabStatus fromCode(String code) {
        return Stream.of(EntryTabStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
