package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 稽核状态
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum InspectStatus {

    _1("1", "未稽核"),
    _2("2", "稽核中"),
    _3("3", "相符"),
    _4("4", "不相符"),
    _5("5", "缺联"),
    _6("6", "重号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InspectStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InspectStatus fromCode(String code) {
        return Stream.of(InspectStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
