package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否取消过勾选
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum IsCancelledCheck {

    _0("0", "否"),
    _1("1", "是");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsCancelledCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsCancelledCheck fromCode(String code) {
        return Stream.of(IsCancelledCheck.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
