package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 代开标记
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum IssueFlag {

    _0("0", "非代开"),
    _1("1", "代开");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IssueFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IssueFlag fromCode(String code) {
        return Stream.of(IssueFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
