package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否有销货清单
 * </p>
 *
 * @author ultraman
 * @since 2023-08-09
 */
public enum SaleListFlag {

    _0("0", "无"),
    _1("1", "有");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SaleListFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SaleListFlag fromCode(String code) {
        return Stream.of(SaleListFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
