package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 下发的事件类型
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
public enum SendEventType {

    _1("1", "通用发票下发事件"),
    _2("2", "发票验真结果下发事件"),
    _3("3", "发票认证结果下发事件"),
    _4("4", "发票匹配结果下发事件"),
    _0("0", "无事件类型");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SendEventType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SendEventType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
