package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真方式
 * </p>
 *
 * @author ultraman
 * @since 2022-07-07
 */
public enum VerifyWay {

    _1("1", "手工输入"),
    _2("2", "外部接口"),
    _3("3", "二维码扫描"),
    _4("4", "系统自动"),
    _5("5", "文件导入"),
    _6("6", "扫描触发"),
    _7("7", "底账触发"),
    _8("8", "发票池触发");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    VerifyWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VerifyWay fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
