package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2022-07-07
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1506096413184299009L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface InvoiceMain {
        static Long id() {
            return 1506506464591839233L;
        }
        static String code() {
            return "invoiceMain";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashier_name");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checker_name");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicer_name");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoice_remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "issue_flag");
        TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "issue_name");
        TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "issue_tax_no");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenant_name");
        TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "sale_list_flag");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoice_color");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoice_orig");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface InvoiceRecog {
        static Long id() {
            return 1506514299060977665L;
        }
        static String code() {
            return "invoiceRecog";
        }
        TypedField<Long> RECOG_ID = new TypedField<>(Long.class, "recog_id");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recog_status");
        TypedField<String> RECOG_USER_NAME = new TypedField<>(String.class, "recog_user_name");
        TypedField<Long> RECOG_USER_ID = new TypedField<>(Long.class, "recog_user_id");
        TypedField<String> RECOG_URL = new TypedField<>(String.class, "recog_url");
        TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "recog_time");
        TypedField<String> RECOG_SHEET = new TypedField<>(String.class, "recog_sheet");
        TypedField<String> FILE_TYPE = new TypedField<>(String.class, "file_type");
        TypedField<String> FILE_SUFFIX = new TypedField<>(String.class, "file_suffix");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> FILE_ORIGIN = new TypedField<>(String.class, "file_origin");
        /**
         * 对一关联关系 关联对象 invoiceView
         */
        TypedField<Long> RECOG_AND_INVOICE_VIEW_RELATION_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> RECOG_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "recogAndInvoiceMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface RECOG_AND_INVOICE_VIEW_RELATION {
                static String code () {
                    return "recogAndInvoiceViewRelation" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "recogAndInvoiceViewRelation.delete_flag");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_type");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.check_user_name");
                TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.check_time");
                TypedField<String> AUTH_STYLE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.auth_style");
                TypedField<String> AUTH_USE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.auth_use");
                TypedField<String> AUTH_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.auth_remark");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.auth_status");
                TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.effective_tax_amount");
                TypedField<String> NO_AUTH_REASON = new TypedField<>(String.class, "recogAndInvoiceViewRelation.no_auth_reason");
                TypedField<LocalDateTime> AUTH_BUSSI_DATE = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.auth_bussi_date");
                TypedField<LocalDateTime> AUTH_TAX_PERIOD = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.auth_tax_period");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_orig");
                TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "recogAndInvoiceViewRelation.cooperate_flag");
                TypedField<String> COMPLIANCE_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.compliance_status");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.retreat_status");
                TypedField<String> RETREAT_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.retreat_remark");
                TypedField<String> HANG_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.hang_status");
                TypedField<String> HANG_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.hang_remark");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.sign_for_status");
                TypedField<LocalDateTime> SIGN_FOR_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.sign_for_time");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.charge_up_no");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.payment_no");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.payment_date");
                TypedField<String> BLACK_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.black_status");
                TypedField<String> BLACK_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.black_remark");
                TypedField<String> TURN_OUT_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.turn_out_status");
                TypedField<BigDecimal> TURN_OUT_AMOUNT = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.turn_out_amount");
                TypedField<LocalDateTime> TURN_OUT_PERIOD = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.turn_out_period");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.audit_status");
                TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.audit_name");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.audit_remark");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.audit_time");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.reserve_amount_without_tax");
                TypedField<BigDecimal> RESERVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.reserve_tax_amount");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.reserve_amount_with_tax");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.paper_drew_date");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "recogAndInvoiceViewRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "recogAndInvoiceViewRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "recogAndInvoiceViewRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "recogAndInvoiceViewRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "recogAndInvoiceViewRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "recogAndInvoiceViewRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "recogAndInvoiceViewRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "recogAndInvoiceViewRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "recogAndInvoiceViewRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.area_name");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.org_id");
                TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.verify_user_id");
                TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "recogAndInvoiceViewRelation.verify_user_name");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.verify_time");
                TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.verify_number");
                TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "recogAndInvoiceViewRelation.verify_remark");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.verify_status");
                TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.verify_sign_status");
                TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "recogAndInvoiceViewRelation.tax_task_id");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.data_status");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_color");
                TypedField<Long> PURCHASER_COMPANY_ID = new TypedField<>(Long.class, "recogAndInvoiceViewRelation.purchaser_company_id");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "recogAndInvoiceViewRelation.purchaser_no");
                TypedField<String> INVOICE_BUSINESS_TYPE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.invoice_business_type");
                TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.recog_status");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "recogAndInvoiceViewRelation.match_status");
                TypedField<String> TURN_OUT_TYPE = new TypedField<>(String.class, "recogAndInvoiceViewRelation.turn_out_type");
                TypedField<LocalDateTime> EL_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.el_time");
                TypedField<String> EXT1 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "recogAndInvoiceViewRelation.ext25");
                TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceViewRelation.recog_time");
            }
            interface RECOG_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "recogAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "recogAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "recogAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "recogAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "recogAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "recogAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "recogAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "recogAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "recogAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "recogAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "recogAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "recogAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "recogAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "recogAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "recogAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "recogAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "recogAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "recogAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "recogAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "recogAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "recogAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "recogAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "recogAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "recogAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "recogAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "recogAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "recogAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "recogAndInvoiceMainRelation.invoice_orig");
            }
        }
    }
    public interface InvoiceVerify {
        static Long id() {
            return 1506545722740408321L;
        }
        static String code() {
            return "invoiceVerify";
        }
        TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "verify_user_name");
        TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "verify_user_id");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "verify_number");
        TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "verify_remark");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "verify_sign_status");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "tax_task_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> VERIFY_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "verifyAndInvoiceMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface VERIFY_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "verifyAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "verifyAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "verifyAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "verifyAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "verifyAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "verifyAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "verifyAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "verifyAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "verifyAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "verifyAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "verifyAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "verifyAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "verifyAndInvoiceMainRelation.invoice_orig");
            }
        }
    }
    public interface InvoiceAuth {
        static Long id() {
            return 1506547698102403074L;
        }
        static String code() {
            return "invoiceAuth";
        }
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "check_time");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<String> AUTH_STYLE = new TypedField<>(String.class, "auth_style");
        TypedField<String> AUTH_USE = new TypedField<>(String.class, "auth_use");
        TypedField<String> AUTH_REMARK = new TypedField<>(String.class, "auth_remark");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "effective_tax_amount");
        TypedField<String> NO_AUTH_REASON = new TypedField<>(String.class, "no_auth_reason");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<LocalDateTime> AUTH_BUSSI_DATE = new TypedField<>(LocalDateTime.class, "auth_bussi_date");
        TypedField<LocalDateTime> AUTH_TAX_PERIOD = new TypedField<>(LocalDateTime.class, "auth_tax_period");
        TypedField<LocalDateTime> EL_TIME = new TypedField<>(LocalDateTime.class, "el_time");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> AUTH_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "authAndInvoiceMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface AUTH_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "authAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "authAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "authAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "authAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "authAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "authAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "authAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "authAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "authAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "authAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "authAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "authAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "authAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "authAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "authAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "authAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "authAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "authAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "authAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "authAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "authAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "authAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "authAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "authAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "authAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "authAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "authAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "authAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "authAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "authAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "authAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "authAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "authAndInvoiceMainRelation.invoice_orig");
            }
        }
    }
    public interface InvoiceMatch {
        static Long id() {
            return 1506551983183724545L;
        }
        static String code() {
            return "invoiceMatch";
        }
        TypedField<String> BUSINESS_ORDER_NO = new TypedField<>(String.class, "business_order_no");
        TypedField<String> BUSINESS_ORDER_ORIGIN = new TypedField<>(String.class, "business_order_origin");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<String> MATCH_USER_NAME = new TypedField<>(String.class, "match_user_name");
        TypedField<Long> MATCH_USER_ID = new TypedField<>(Long.class, "match_user_id");
        TypedField<BigDecimal> MATCH_AMOUNT = new TypedField<>(BigDecimal.class, "match_amount");
        TypedField<LocalDateTime> MATCH_TIME = new TypedField<>(LocalDateTime.class, "match_time");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<Long> BUSINESS_ORDER_ID = new TypedField<>(Long.class, "business_order_id");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> MATCH_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "matchAndInvoiceMainRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceView
         */
        TypedField<Long> MATCH_AND_INVOICE_VIEW_RELATION_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface MATCH_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "matchAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "matchAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "matchAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "matchAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "matchAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "matchAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "matchAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "matchAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "matchAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "matchAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "matchAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "matchAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "matchAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "matchAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "matchAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "matchAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "matchAndInvoiceMainRelation.invoice_orig");
            }
            interface MATCH_AND_INVOICE_VIEW_RELATION {
                static String code () {
                    return "matchAndInvoiceViewRelation" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "matchAndInvoiceViewRelation.delete_flag");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_type");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.check_user_name");
                TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.check_time");
                TypedField<String> AUTH_STYLE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.auth_style");
                TypedField<String> AUTH_USE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.auth_use");
                TypedField<String> AUTH_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.auth_remark");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.auth_status");
                TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.effective_tax_amount");
                TypedField<String> NO_AUTH_REASON = new TypedField<>(String.class, "matchAndInvoiceViewRelation.no_auth_reason");
                TypedField<LocalDateTime> AUTH_BUSSI_DATE = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.auth_bussi_date");
                TypedField<LocalDateTime> AUTH_TAX_PERIOD = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.auth_tax_period");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_orig");
                TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "matchAndInvoiceViewRelation.cooperate_flag");
                TypedField<String> COMPLIANCE_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.compliance_status");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.retreat_status");
                TypedField<String> RETREAT_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.retreat_remark");
                TypedField<String> HANG_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.hang_status");
                TypedField<String> HANG_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.hang_remark");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.sign_for_status");
                TypedField<LocalDateTime> SIGN_FOR_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.sign_for_time");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.charge_up_no");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.payment_no");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.payment_date");
                TypedField<String> BLACK_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.black_status");
                TypedField<String> BLACK_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.black_remark");
                TypedField<String> TURN_OUT_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.turn_out_status");
                TypedField<BigDecimal> TURN_OUT_AMOUNT = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.turn_out_amount");
                TypedField<LocalDateTime> TURN_OUT_PERIOD = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.turn_out_period");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.audit_status");
                TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.audit_name");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.audit_remark");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.audit_time");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.reserve_amount_without_tax");
                TypedField<BigDecimal> RESERVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.reserve_tax_amount");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.reserve_amount_with_tax");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.paper_drew_date");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "matchAndInvoiceViewRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "matchAndInvoiceViewRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "matchAndInvoiceViewRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "matchAndInvoiceViewRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "matchAndInvoiceViewRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "matchAndInvoiceViewRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "matchAndInvoiceViewRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "matchAndInvoiceViewRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "matchAndInvoiceViewRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.area_name");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.org_id");
                TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.verify_user_id");
                TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "matchAndInvoiceViewRelation.verify_user_name");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.verify_time");
                TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.verify_number");
                TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "matchAndInvoiceViewRelation.verify_remark");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.verify_status");
                TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.verify_sign_status");
                TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "matchAndInvoiceViewRelation.tax_task_id");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.data_status");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_color");
                TypedField<Long> PURCHASER_COMPANY_ID = new TypedField<>(Long.class, "matchAndInvoiceViewRelation.purchaser_company_id");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "matchAndInvoiceViewRelation.purchaser_no");
                TypedField<String> INVOICE_BUSINESS_TYPE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.invoice_business_type");
                TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.recog_status");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "matchAndInvoiceViewRelation.match_status");
                TypedField<String> TURN_OUT_TYPE = new TypedField<>(String.class, "matchAndInvoiceViewRelation.turn_out_type");
                TypedField<LocalDateTime> EL_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.el_time");
                TypedField<String> EXT1 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "matchAndInvoiceViewRelation.ext25");
                TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "matchAndInvoiceViewRelation.recog_time");
            }
        }
    }
    public interface InvoiceBusiness {
        static Long id() {
            return 1506555519594364929L;
        }
        static String code() {
            return "invoiceBusiness";
        }
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "cooperate_flag");
        TypedField<String> COMPLIANCE_STATUS = new TypedField<>(String.class, "compliance_status");
        TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "retreat_status");
        TypedField<String> RETREAT_REMARK = new TypedField<>(String.class, "retreat_remark");
        TypedField<String> HANG_STATUS = new TypedField<>(String.class, "hang_status");
        TypedField<String> HANG_REMARK = new TypedField<>(String.class, "hang_remark");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<LocalDateTime> SIGN_FOR_TIME = new TypedField<>(LocalDateTime.class, "sign_for_time");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> BLACK_STATUS = new TypedField<>(String.class, "black_status");
        TypedField<String> BLACK_REMARK = new TypedField<>(String.class, "black_remark");
        TypedField<String> TURN_OUT_STATUS = new TypedField<>(String.class, "turn_out_status");
        TypedField<String> TURN_OUT_TYPE = new TypedField<>(String.class, "turn_out_type");
        TypedField<BigDecimal> TURN_OUT_AMOUNT = new TypedField<>(BigDecimal.class, "turn_out_amount");
        TypedField<LocalDateTime> TURN_OUT_PERIOD = new TypedField<>(LocalDateTime.class, "turn_out_period");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "audit_name");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<BigDecimal> RESERVE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "reserve_amount_without_tax");
        TypedField<BigDecimal> RESERVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "reserve_tax_amount");
        TypedField<BigDecimal> RESERVE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "reserve_amount_with_tax");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> PURCHASER_COMPANY_ID = new TypedField<>(Long.class, "purchaser_company_id");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> INVOICE_BUSINESS_TYPE = new TypedField<>(String.class, "invoice_business_type");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recog_status");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> BUSINESS_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "businessAndInvoiceMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BUSINESS_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "businessAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "businessAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "businessAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "businessAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "businessAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "businessAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "businessAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "businessAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "businessAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "businessAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "businessAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "businessAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "businessAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "businessAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "businessAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "businessAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "businessAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "businessAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "businessAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "businessAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "businessAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "businessAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "businessAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "businessAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "businessAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "businessAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "businessAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "businessAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "businessAndInvoiceMainRelation.invoice_orig");
            }
        }
    }
    public interface InvoiceView {
        static Long id() {
            return 1513359788452577282L;
        }
        static String code() {
            return "invoiceView";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "check_user_id");
        TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "check_user_name");
        TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "check_time");
        TypedField<String> AUTH_STYLE = new TypedField<>(String.class, "auth_style");
        TypedField<String> AUTH_USE = new TypedField<>(String.class, "auth_use");
        TypedField<String> AUTH_REMARK = new TypedField<>(String.class, "auth_remark");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "effective_tax_amount");
        TypedField<String> NO_AUTH_REASON = new TypedField<>(String.class, "no_auth_reason");
        TypedField<LocalDateTime> AUTH_BUSSI_DATE = new TypedField<>(LocalDateTime.class, "auth_bussi_date");
        TypedField<LocalDateTime> AUTH_TAX_PERIOD = new TypedField<>(LocalDateTime.class, "auth_tax_period");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoice_orig");
        TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "cooperate_flag");
        TypedField<String> COMPLIANCE_STATUS = new TypedField<>(String.class, "compliance_status");
        TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "retreat_status");
        TypedField<String> RETREAT_REMARK = new TypedField<>(String.class, "retreat_remark");
        TypedField<String> HANG_STATUS = new TypedField<>(String.class, "hang_status");
        TypedField<String> HANG_REMARK = new TypedField<>(String.class, "hang_remark");
        TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "sign_for_status");
        TypedField<LocalDateTime> SIGN_FOR_TIME = new TypedField<>(LocalDateTime.class, "sign_for_time");
        TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "charge_up_status");
        TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "charge_up_period");
        TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "charge_up_no");
        TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "payment_status");
        TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "payment_no");
        TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "payment_date");
        TypedField<String> BLACK_STATUS = new TypedField<>(String.class, "black_status");
        TypedField<String> BLACK_REMARK = new TypedField<>(String.class, "black_remark");
        TypedField<String> TURN_OUT_STATUS = new TypedField<>(String.class, "turn_out_status");
        TypedField<BigDecimal> TURN_OUT_AMOUNT = new TypedField<>(BigDecimal.class, "turn_out_amount");
        TypedField<LocalDateTime> TURN_OUT_PERIOD = new TypedField<>(LocalDateTime.class, "turn_out_period");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "audit_name");
        TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "audit_remark");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<BigDecimal> RESERVE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "reserve_amount_without_tax");
        TypedField<BigDecimal> RESERVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "reserve_tax_amount");
        TypedField<BigDecimal> RESERVE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "reserve_amount_with_tax");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "machine_code");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "cipher_text");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashier_name");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checker_name");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicer_name");
        TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "purchaser_addr_tel");
        TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_name_account");
        TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "seller_addr_tel");
        TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "seller_bank_name_account");
        TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoice_remark");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "issue_flag");
        TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "issue_name");
        TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "issue_tax_no");
        TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "special_invoice_flag");
        TypedField<String> TENANT_NAME = new TypedField<>(String.class, "tenant_name");
        TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "sale_list_flag");
        TypedField<String> AREA_CODE = new TypedField<>(String.class, "area_code");
        TypedField<String> AREA_NAME = new TypedField<>(String.class, "area_name");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "verify_user_id");
        TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "verify_user_name");
        TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "verify_time");
        TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "verify_number");
        TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "verify_remark");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "verify_sign_status");
        TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "tax_task_id");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoice_color");
        TypedField<Long> PURCHASER_COMPANY_ID = new TypedField<>(Long.class, "purchaser_company_id");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> INVOICE_BUSINESS_TYPE = new TypedField<>(String.class, "invoice_business_type");
        TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recog_status");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<String> TURN_OUT_TYPE = new TypedField<>(String.class, "turn_out_type");
        TypedField<LocalDateTime> EL_TIME = new TypedField<>(LocalDateTime.class, "el_time");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "recog_time");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_VIEW_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceMainRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceVerify
         */
        TypedField<Long> INVOICE_VIEW_AND_INVOICE_VERIFY_RELATION_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceAuth
         */
        TypedField<Long> INVOICE_VIEW_AND_INVOICE_AUTH_RELATION_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceBusiness
         */
        TypedField<Long> INVOICE_VIEW_AND_INVOICE_BUSINESS_RELATION_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_VIEW_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "invoiceViewAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceViewAndInvoiceMainRelation.invoice_orig");
            }
            interface INVOICE_VIEW_AND_INVOICE_VERIFY_RELATION {
                static String code () {
                    return "invoiceViewAndInvoiceVerifyRelation" ;
                }
                TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.verify_user_name");
                TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.verify_user_id");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceVerifyRelation.verify_time");
                TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.verify_number");
                TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.verify_remark");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.verify_status");
                TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.verify_sign_status");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.data_status");
                TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.tax_task_id");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceVerifyRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceVerifyRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceVerifyRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceVerifyRelation.org_id");
            }
            interface INVOICE_VIEW_AND_INVOICE_AUTH_RELATION {
                static String code () {
                    return "invoiceViewAndInvoiceAuthRelation" ;
                }
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.org_id");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.check_user_id");
                TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceAuthRelation.check_time");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.data_status");
                TypedField<String> AUTH_STYLE = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.auth_style");
                TypedField<String> AUTH_USE = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.auth_use");
                TypedField<String> AUTH_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.auth_remark");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.auth_status");
                TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceAuthRelation.effective_tax_amount");
                TypedField<String> NO_AUTH_REASON = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.no_auth_reason");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceAuthRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceAuthRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceAuthRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.delete_flag");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceAuthRelation.check_user_name");
                TypedField<LocalDateTime> AUTH_BUSSI_DATE = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceAuthRelation.auth_bussi_date");
                TypedField<LocalDateTime> AUTH_TAX_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceAuthRelation.auth_tax_period");
                TypedField<LocalDateTime> EL_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceAuthRelation.el_time");
            }
            interface INVOICE_VIEW_AND_INVOICE_BUSINESS_RELATION {
                static String code () {
                    return "invoiceViewAndInvoiceBusinessRelation" ;
                }
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.org_id");
                TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.cooperate_flag");
                TypedField<String> COMPLIANCE_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.compliance_status");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.retreat_status");
                TypedField<String> RETREAT_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.retreat_remark");
                TypedField<String> HANG_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.hang_status");
                TypedField<String> HANG_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.hang_remark");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.sign_for_status");
                TypedField<LocalDateTime> SIGN_FOR_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.sign_for_time");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.charge_up_no");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.payment_no");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.payment_date");
                TypedField<String> BLACK_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.black_status");
                TypedField<String> BLACK_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.black_remark");
                TypedField<String> TURN_OUT_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.turn_out_status");
                TypedField<String> TURN_OUT_TYPE = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.turn_out_type");
                TypedField<BigDecimal> TURN_OUT_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceBusinessRelation.turn_out_amount");
                TypedField<LocalDateTime> TURN_OUT_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.turn_out_period");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.audit_status");
                TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.audit_name");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.audit_remark");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.audit_time");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceBusinessRelation.reserve_amount_without_tax");
                TypedField<BigDecimal> RESERVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceBusinessRelation.reserve_tax_amount");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceViewAndInvoiceBusinessRelation.reserve_amount_with_tax");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.data_status");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceViewAndInvoiceBusinessRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.delete_flag");
                TypedField<Long> PURCHASER_COMPANY_ID = new TypedField<>(Long.class, "invoiceViewAndInvoiceBusinessRelation.purchaser_company_id");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.purchaser_no");
                TypedField<String> INVOICE_BUSINESS_TYPE = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.invoice_business_type");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.match_status");
                TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.recog_status");
                TypedField<String> EXT1 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "invoiceViewAndInvoiceBusinessRelation.ext25");
            }
        }
    }
    public interface InvoiceItem {
        static Long id() {
            return 1513727837537931265L;
        }
        static String code() {
            return "invoiceItem";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> CARGO_CODE = new TypedField<>(String.class, "cargo_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> TAX_RATE_TYPE = new TypedField<>(String.class, "tax_rate_type");
        TypedField<LocalDateTime> TOLL_START_DATE = new TypedField<>(LocalDateTime.class, "toll_start_date");
        TypedField<LocalDateTime> TOLL_END_DATE = new TypedField<>(LocalDateTime.class, "toll_end_date");
        TypedField<String> PLATE_NUMBER = new TypedField<>(String.class, "plate_number");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<BigDecimal> DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "discount_without_tax");
        TypedField<BigDecimal> DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "discount_tax");
        TypedField<BigDecimal> DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "discount_with_tax");
        TypedField<BigDecimal> DISCOUNT_RATE = new TypedField<>(BigDecimal.class, "discount_rate");
        TypedField<String> TAX_ITEM = new TypedField<>(String.class, "tax_item");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goods_no_ver");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> GOODS_ERP_NO = new TypedField<>(String.class, "goods_erp_no");
        TypedField<String> TAX_PRE_FLAG = new TypedField<>(String.class, "tax_pre_flag");
        TypedField<String> TAX_PRE_CONTENT = new TypedField<>(String.class, "tax_pre_content");
        TypedField<BigDecimal> TAX_DEDUNCTION = new TypedField<>(BigDecimal.class, "tax_dedunction");
        TypedField<String> DISCOUNT_FLAG = new TypedField<>(String.class, "discount_flag");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        /**
         * 对一关联关系 关联对象 invoiceView
         */
        TypedField<Long> INVOICE_ITEM_AND_INVOICE_VIEW_RELATION_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.id");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_ITEM_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_ITEM_AND_INVOICE_VIEW_RELATION {
                static String code () {
                    return "invoiceItemAndInvoiceViewRelation" ;
                }
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.delete_flag");
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_type");
                TypedField<Long> CHECK_USER_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.check_user_id");
                TypedField<String> CHECK_USER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.check_user_name");
                TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.check_time");
                TypedField<String> AUTH_STYLE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.auth_style");
                TypedField<String> AUTH_USE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.auth_use");
                TypedField<String> AUTH_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.auth_remark");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.auth_status");
                TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.effective_tax_amount");
                TypedField<String> NO_AUTH_REASON = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.no_auth_reason");
                TypedField<LocalDateTime> AUTH_BUSSI_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.auth_bussi_date");
                TypedField<LocalDateTime> AUTH_TAX_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.auth_tax_period");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_orig");
                TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.cooperate_flag");
                TypedField<String> COMPLIANCE_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.compliance_status");
                TypedField<String> RETREAT_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.retreat_status");
                TypedField<String> RETREAT_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.retreat_remark");
                TypedField<String> HANG_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.hang_status");
                TypedField<String> HANG_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.hang_remark");
                TypedField<String> SIGN_FOR_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.sign_for_status");
                TypedField<LocalDateTime> SIGN_FOR_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.sign_for_time");
                TypedField<String> CHARGE_UP_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.charge_up_status");
                TypedField<LocalDateTime> CHARGE_UP_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.charge_up_period");
                TypedField<String> CHARGE_UP_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.charge_up_no");
                TypedField<String> PAYMENT_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.payment_status");
                TypedField<String> PAYMENT_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.payment_no");
                TypedField<LocalDateTime> PAYMENT_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.payment_date");
                TypedField<String> BLACK_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.black_status");
                TypedField<String> BLACK_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.black_remark");
                TypedField<String> TURN_OUT_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.turn_out_status");
                TypedField<BigDecimal> TURN_OUT_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.turn_out_amount");
                TypedField<LocalDateTime> TURN_OUT_PERIOD = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.turn_out_period");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.audit_status");
                TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.audit_name");
                TypedField<String> AUDIT_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.audit_remark");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.audit_time");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.reserve_amount_without_tax");
                TypedField<BigDecimal> RESERVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.reserve_tax_amount");
                TypedField<BigDecimal> RESERVE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.reserve_amount_with_tax");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.paper_drew_date");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceViewRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.area_name");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.org_id");
                TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.verify_user_id");
                TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.verify_user_name");
                TypedField<LocalDateTime> VERIFY_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.verify_time");
                TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.verify_number");
                TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.verify_remark");
                TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.verify_status");
                TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.verify_sign_status");
                TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.tax_task_id");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.data_status");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_color");
                TypedField<Long> PURCHASER_COMPANY_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceViewRelation.purchaser_company_id");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.purchaser_no");
                TypedField<String> INVOICE_BUSINESS_TYPE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.invoice_business_type");
                TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.recog_status");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.match_status");
                TypedField<String> TURN_OUT_TYPE = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.turn_out_type");
                TypedField<LocalDateTime> EL_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.el_time");
                TypedField<String> EXT1 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "invoiceItemAndInvoiceViewRelation.ext25");
                TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceViewRelation.recog_time");
            }
            interface INVOICE_ITEM_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "invoiceItemAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceItemAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceItemAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceItemAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceItemAndInvoiceMainRelation.invoice_orig");
            }
        }
    }
    public interface InvoiceVehicle {
        static Long id() {
            return 1513766827953422337L;
        }
        static String code() {
            return "invoiceVehicle";
        }
        TypedField<String> ORGANIZATION_CODE = new TypedField<>(String.class, "organization_code");
        TypedField<String> VEHICLE_TYPE = new TypedField<>(String.class, "vehicle_type");
        TypedField<String> VEHICLE_BRAND = new TypedField<>(String.class, "vehicle_brand");
        TypedField<String> PRODUCTION_AREA = new TypedField<>(String.class, "production_area");
        TypedField<String> CERT_NO = new TypedField<>(String.class, "cert_no");
        TypedField<String> INSPECTION_NO = new TypedField<>(String.class, "inspection_no");
        TypedField<String> ENGINE_NO = new TypedField<>(String.class, "engine_no");
        TypedField<String> VEHICLE_NO = new TypedField<>(String.class, "vehicle_no");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> TONNAGE = new TypedField<>(String.class, "tonnage");
        TypedField<String> MAX_CAPACITY = new TypedField<>(String.class, "max_capacity");
        TypedField<String> IMPORT_CERT_NO = new TypedField<>(String.class, "import_cert_no");
        TypedField<String> TAX_AUTH_NAME = new TypedField<>(String.class, "tax_auth_name");
        TypedField<String> TAX_AUTH_CODE = new TypedField<>(String.class, "tax_auth_code");
        TypedField<String> TAX_PAID_PROOF = new TypedField<>(String.class, "tax_paid_proof");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        /**
         * 对一关联关系 关联对象 invoiceMain
         */
        TypedField<Long> INVOICE_VEHICLE_AND_INVOICE_MAIN_RELATION_ID = new TypedField<>(Long.class, "invoiceVehicleAndInvoiceMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface INVOICE_VEHICLE_AND_INVOICE_MAIN_RELATION {
                static String code () {
                    return "invoiceVehicleAndInvoiceMainRelation" ;
                }
                TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_no");
                TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_code");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_type");
                TypedField<String> DATA_STATUS = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.data_status");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoiceVehicleAndInvoiceMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "invoiceVehicleAndInvoiceMainRelation.tax_amount");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoiceVehicleAndInvoiceMainRelation.amount_with_tax");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.purchaser_tax_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.seller_tax_no");
                TypedField<String> MACHINE_CODE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.machine_code");
                TypedField<String> CHECK_CODE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.check_code");
                TypedField<String> CIPHER_TEXT = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.cipher_text");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.cashier_name");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.checker_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoicer_name");
                TypedField<String> PURCHASER_ADDR_TEL = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.purchaser_addr_tel");
                TypedField<String> PURCHASER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.purchaser_bank_name_account");
                TypedField<String> SELLER_ADDR_TEL = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.seller_addr_tel");
                TypedField<String> SELLER_BANK_NAME_ACCOUNT = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.seller_bank_name_account");
                TypedField<String> INVOICE_REMARK = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_remark");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.origin_invoice_code");
                TypedField<String> ISSUE_FLAG = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.issue_flag");
                TypedField<String> ISSUE_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.issue_name");
                TypedField<String> ISSUE_TAX_NO = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.issue_tax_no");
                TypedField<String> SPECIAL_INVOICE_FLAG = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.special_invoice_flag");
                TypedField<String> TENANT_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.tenant_name");
                TypedField<String> SALE_LIST_FLAG = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.sale_list_flag");
                TypedField<String> AREA_CODE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.area_code");
                TypedField<String> AREA_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.area_name");
                TypedField<Long> ID = new TypedField<>(Long.class, "invoiceVehicleAndInvoiceMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "invoiceVehicleAndInvoiceMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceVehicleAndInvoiceMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "invoiceVehicleAndInvoiceMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "invoiceVehicleAndInvoiceMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "invoiceVehicleAndInvoiceMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.delete_flag");
                TypedField<Long> ORG_ID = new TypedField<>(Long.class, "invoiceVehicleAndInvoiceMainRelation.org_id");
                TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "invoiceVehicleAndInvoiceMainRelation.paper_drew_date");
                TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_color");
                TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_status");
                TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoiceVehicleAndInvoiceMainRelation.invoice_orig");
            }
        }
    }
    public interface InvoiceOperateLog {
        static Long id() {
            return 1523539078565560321L;
        }
        static String code() {
            return "invoiceOperateLog";
        }
        TypedField<String> OPERATE_USER_NAME = new TypedField<>(String.class, "operate_user_name");
        TypedField<Long> OPERATE_USER_ID = new TypedField<>(Long.class, "operate_user_id");
        TypedField<String> OPERATE_SUMMARY = new TypedField<>(String.class, "operate_summary");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<String> OPERATE_PARAM = new TypedField<>(String.class, "operate_param");
        TypedField<String> OPERATE_RESULT = new TypedField<>(String.class, "operate_result");
        TypedField<Long> INVOICE_ID = new TypedField<>(Long.class, "invoice_id");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface InvoicePushLog {
        static Long id() {
            return 1526097007385513986L;
        }
        static String code() {
            return "invoicePushLog";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SEND_STATUS = new TypedField<>(String.class, "send_status");
        TypedField<LocalDateTime> SEND_TIME = new TypedField<>(LocalDateTime.class, "send_time");
        TypedField<String> SEND_TYPE = new TypedField<>(String.class, "send_type");
        TypedField<String> SEND_DATA_SOURCE = new TypedField<>(String.class, "send_data_source");
        TypedField<String> BACK_STATUS = new TypedField<>(String.class, "back_status");
        TypedField<LocalDateTime> BACK_TIME = new TypedField<>(LocalDateTime.class, "back_time");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> SEND_EVENT_TYPE = new TypedField<>(String.class, "send_event_type");
    }
    public interface InvoiceReceiveLog {
        static Long id() {
            return 1536609593139003393L;
        }
        static String code() {
            return "invoiceReceiveLog";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> FILE_URL = new TypedField<>(String.class, "file_url");
        TypedField<String> INVOICE_ORIG = new TypedField<>(String.class, "invoice_orig");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RECEIVE_STATUS = new TypedField<>(String.class, "receive_status");
    }
    public interface InvoiceVerifyTask {
        static Long id() {
            return 1541326933866889217L;
        }
        static String code() {
            return "invoiceVerifyTask";
        }
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> CHECK_CODE = new TypedField<>(String.class, "check_code");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
        TypedField<String> VERIFY_USER_NAME = new TypedField<>(String.class, "verify_user_name");
        TypedField<Long> VERIFY_USER_ID = new TypedField<>(Long.class, "verify_user_id");
        TypedField<LocalDateTime> VERIFY_REQUEST_TIME = new TypedField<>(LocalDateTime.class, "verify_request_time");
        TypedField<LocalDateTime> VERIFY_RESULT_RESPONSE_TIME = new TypedField<>(LocalDateTime.class, "verify_result_response_time");
        TypedField<String> TAX_TASK_ID = new TypedField<>(String.class, "tax_task_id");
        TypedField<String> TAX_API_CODE = new TypedField<>(String.class, "tax_api_code");
        TypedField<String> VERIFY_WAY = new TypedField<>(String.class, "verify_way");
        TypedField<Long> VERIFY_NUMBER = new TypedField<>(Long.class, "verify_number");
        TypedField<String> VERIFY_REMARK = new TypedField<>(String.class, "verify_remark");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verify_status");
        TypedField<String> VERIFY_SIGN_STATUS = new TypedField<>(String.class, "verify_sign_status");
        TypedField<Long> ORG_ID = new TypedField<>(Long.class, "org_id");
        TypedField<String> DATA_STATUS = new TypedField<>(String.class, "data_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SERIAL_NUMBER = new TypedField<>(String.class, "serial_number");
        TypedField<String> PROCESS_STATUS = new TypedField<>(String.class, "process_status");
        TypedField<String> VERIFY_PROPERTY = new TypedField<>(String.class, "verify_property");
    }
}
