package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * logistics_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum LogisticsStatus {

    _0("0", "未寄送"),
    _1("1", "寄送中"),
    _2("2", "已签收");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    LogisticsStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LogisticsStatus fromCode(String code) {
        return Stream.of(LogisticsStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
