package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ncp_manage_status
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum NcpManageStatus {

    _0("0", "无"),
    _01("01", "正常"),
    _03("03", "疑点发票"),
    _02("02", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NcpManageStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NcpManageStatus fromCode(String code) {
        return Stream.of(NcpManageStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
