package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_compliance_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum NoComplianceType {

    _0("0", "无"),
    _1("1", "购方抬头不一致"),
    _2("2", "购方地址电话不一致"),
    _3("3", "购方银行账号不一致"),
    _4("4", "销方失信"),
    _5("5", "敏感词(销方名称)"),
    _6("6", "发票状态异常"),
    _7("7", "购方公司未维护"),
    _8("8", "其他"),
    _9("9", "含有自定义预警项"),
    _10("10", "敏感词(商品名称)"),
    _11("11", "自定义预警"),
    _12("12", "勾选异常"),
    _13("13", "抵扣异常"),
    _14("14", "发票转异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NoComplianceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoComplianceType fromCode(String code) {
        return Stream.of(NoComplianceType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
