package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operate_type
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum OperateType {

    _0("0", "未知"),
    _1("1", "农产品发票加计扣除操作"),
    _2("2", "发票退票操作"),
    _3("3", "发票影像删除操作"),
    _4("4", "发票删除操作"),
    _5("5", "手动验真操作"),
    _6("6", "风险发票手动跟进操作"),
    _7("7", "风险发票手动添加操作"),
    _8("8", "风险发票手动解除管控操作"),
    _9("9", "风险发票自动管控(退票)/自动解除管控(取消退票)操作"),
    _10("10", "发票取消退票操作"),
    _11("11", "下载影像"),
    _12("12", "修改扩展信息"),
    _13("13", "发票影像提交操作"),
    _14("14", "国税底账"),
    _15("15", "发票转交异常操作"),
    _16("16", "验真来源消息处理"),
    _17("17", "协同直连消息处理"),
    _18("18", "协同抽取消息处理"),
    _19("19", "协同手工回填消息处理"),
    _20("20", "影像识别消息处理"),
    _21("21", "票税助手消息处理"),
    _22("22", "接口上传消息处理"),
    _23("23", "农产品同步消息处理"),
    _24("24", "文件导入消息处理"),
    _25("25", "进项发票归集消息处理"),
    _26("26", "农产品加计扣除同步消息处理"),
    _27("27", "销项归集发票消息处理"),
    _28("28", "万科属地消息处理"),
    _29("29", "业务单签收日志消息处理"),
    _30("30", "业务单审核状态消息处理"),
    _32("32", "发票锁定解锁操作"),
    _31("31", "发票勾选操作");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperateType fromCode(String code) {
        return Stream.of(OperateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
