package com.xforceplus.ultraman.app.purchaserinvoicesaas.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * recog_sheet
 * </p>
 *
 * @author ultraman
 * @since 2023-11-13
 */
public enum RecogSheet {

    _0("0", "无"),
    _1("1", "发票联"),
    _2("2", "抵扣联"),
    _3("3", "存根联"),
    _4("4", "记账联");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecogSheet(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecogSheet fromCode(String code) {
        return Stream.of(RecogSheet.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
